<?php
namespace App\Models;
use Illuminate\Database\Eloquent\Model;

class PackageDetail extends Model {

    protected $table = 'package_details';

    protected $casts = [
        'start_date' => 'datetime:Y-m-d',
        'end_date'   => 'datetime:Y-m-d',
        'facilities' => 'array',
    ];

    

    protected $fillable = ['package_id','start_date','end_date','duration_days','duration_nights','itinerary_overview','includes','excludes','tour_highlights','route_details','facilities'];

    public function package(){ 
        return $this->belongsTo(Package::class,'id','package_id'); 
    }
}
