<?php
namespace App\Models;
use Illuminate\Database\Eloquent\Model;

class HotelRoom extends Model {

    protected $table = 'hotel_rooms';

    protected $fillable = ['hotel_id','title','details','is_active','is_deleted'];

    public function hotel(){ 
        return $this->belongsTo(Hotel::class,'id','hotel_id'); 
    }

    public function images()
    { 
        return $this->hasMany(HotelRoomImage::class, 'room_id', 'id');
    }
}
