<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Hotel extends Model
{
    use HasFactory;

    /**
     * The table associated with the model.
     *
     * @var string
     */
    protected $table = 'hotels';

    /**
     * The attributes that are mass assignable.
     *
     * @var array<int, string>
     */
    protected $fillable = [
        'title',
        'slug',
        'location',
        'primary_image',
        'primary_image_alt',
        'short_description',
        'refund_cancellation_policy',
        'facilities',
        'is_active',
        'is_top_luxury',
        'is_deleted',
    ];

    /**
     * The attributes that should be cast.
     *
     * @var array<string, string>
     */
    protected $casts = [
        'is_active' => 'boolean',
        'is_deleted' => 'boolean',
        'facilities' => 'array',
    ];

    public function images()
    { 
        return $this->hasMany(HotelImage::class,'hotel_id','id'); 
    }

    public function rooms()
    {
        return $this->hasMany(HotelRoom::class,'hotel_id','id');
    }

    public function faqs()
    {
        return $this->hasMany(HotelFaq::class,'hotel_id','id');
    }

    public function enquiries()
    {
        return $this->hasMany(EnquiryHotel::class, 'hotel_id');
    }

    public function todos()
    {
        return $this->hasMany(HotelToDo::class,'hotel_id','id');
    }

    public function reviews()
    { 
        return $this->hasMany(Review::class,'hotel_id','id');
    }

    public function meta()
    {
        return $this->hasOne(HotelMetaData::class, 'hotel_id', 'id');
    }

}
