<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class EnquiryPackage extends Model
{
    use HasFactory;

    protected $table = 'enquiry_package';

    protected $fillable = [
        'package_id',
        'name',
        'email',
        'phone',
        'country',
        'no_of_travellers',
        'city',
        'per_person_budget',
        'month',
        'arrival_city',
        'departure_city',
        'message',
        'is_confirmed',
        'is_deleted',
    ];

    protected $casts = [
        'is_deleted' => 'boolean'
    ];

    public function package()
    {
        return $this->belongsTo(Package::class, 'package_id');
    }
}
