<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class EnquiryGeneral extends Model
{
    use HasFactory;

    protected $table = 'enquiry_general';

    protected $fillable = [
        'name',
        'email',
        'phone',
        'no_of_travellers',
        'start_date',
        'message',
        'city',
        'travel_type',
        'month',
        'country',
        'is_get_in_touch',
        'is_confirmed',
        'is_deleted',
    ];

    protected $casts = [
        'is_deleted' => 'boolean'
    ];

    public function hotel()
    {
        return $this->belongsTo(Hotel::class, 'hotel_id');
    }
}
