<?php

namespace App\Http\Resources;

use Illuminate\Http\Resources\Json\JsonResource;

class TrainTourResource extends JsonResource
{
    public function toArray($request)
    {
        return [
            'title'             => $this->title,
            'slug'              => $this->slug,
            'primary_image'     => $this->primary_image ? storage_link($this->primary_image) : null,
            'primary_image_alt' => $this->title,
            'description'       => $this->description,
            'refund_cancellation_policy' => $this->refund_cancellation_policy,

            'details' => new TrainTourDetailResource($this->whenLoaded('details')),

            'cabins' => TrainCabinResource::collection($this->whenLoaded('cabins')),

            'itineraries' => $this->whenLoaded('itineraries', function () {
                return $this->itineraries->map(fn($itinerary) => [
                    'title'   => $itinerary->title,
                    'details' => $itinerary->details
                ]);
            }),

            'faqs' => $this->whenLoaded('faqs', function () {
                return $this->faqs->map(fn($faq) => [
                    'question' => $faq->question,
                    'answer'   => $faq->answer,
                ]);
            }),

            'meta' => $this->whenLoaded('meta', function () {
                return [
                    'meta_title'         => $this->meta->meta_title ?? null,
                    'meta_description'   => $this->meta->meta_description ?? null,
                    'meta_keywords'      => $this->meta->meta_keywords ?? null,
                    'h1_heading'         =>$this->meta->h1_heading,
                    'meta_details'       => $this->meta->meta_details ?? null,
                ];
            }),

            'train' => new TrainResource($this->whenLoaded('train')),
        ];
    }
}
