<?php

namespace App\Http\Resources;

use Illuminate\Http\Resources\Json\JsonResource;

class TrainTourDetailResource extends JsonResource
{
    public function toArray($request)
    {
        return [
            'duration_days'       => $this->duration_days,
            'duration_nights'     => $this->duration_nights,
            'itinerary_overview'  => $this->itinerary_overview,
            'includes'            => $this->formatArray($this->includes),
            'excludes'            => $this->formatArray($this->excludes),
            'route_details'       => $this->route_details,
            'map_image'           => $this->map_image ? storage_link($this->map_image): null,
            'facilities'          => $this->facilities ?? [],
        ];
    }

    /**
     * Ensure includes/excludes are always arrays.
     */
    private function formatArray($value)
    {
        if (is_null($value)) return [];
        if (is_array($value)) return $value;
        return preg_split('/[\r\n#]+/', $value, -1, PREG_SPLIT_NO_EMPTY);
    }
}
