<?php

namespace App\Http\Resources;

use Illuminate\Http\Resources\Json\JsonResource;

class PackageResource extends JsonResource
{
    public function toArray($request)
    {
        return [
            'title'         => $this->title,
            'slug'          => $this->slug,
            'primary_image' => $this->primary_image ? storage_link($this->primary_image): null,
            'primary_image_alt' =>$this->primary_image_alt,
            'short_description' => $this->short_description,
            'long_description'  => $this->long_description,
            'rating' => round($this->reviews_avg_rating, 1),
            'total_review' => $this->reviews_count,

            'images' => $this->whenLoaded('images', function () {
                return $this->images->map(fn($img) => [
                    'image_path' => $img->image_path ? storage_link($img->image_path): null,
                    'image_alt' => $img->image_alt,
                ]);
            }),

            'itineraries' => $this->whenLoaded('itineraries', function () {
                return $this->itineraries->map(fn($itinerary) => [
                    'title'   => $itinerary->title,
                    'details' => $itinerary->details
                ]);
            }),

            'faqs' => $this->whenLoaded('faqs', function () {
                return $this->faqs->map(fn($faq) => [
                    'question'   => $faq->question,
                    'answer' => $faq->answer
                ]);
            }),

            'reviews' => $this->whenLoaded('reviews', function () {
                return $this->reviews->map(fn($review) => [
                    'customer_name'   => $review->customer_name,
                    'rating' => $review->rating,
                    'comment' => $review->comment
                ]);
            }),

            'category'    => new CategoryResource($this->whenLoaded('category')),
            'details'     => new PackageDetailResource($this->whenLoaded('details')),
            'location'    => new LocationResource($this->whenLoaded('location')),
            'meta' => $this->whenLoaded('meta', function () {
                return [
                    'meta_title'         => $this->meta->meta_title ?? null,
                    'meta_description'   => $this->meta->meta_description ?? null,
                    'meta_keywords'      => $this->meta->meta_keywords ?? null,
                    'h1_heading'         => $this->meta->h1_heading,
                    'meta_details'       => $this->meta->meta_details ?? null,
                ];
            }),
        ];
    }
}

