<?php

namespace App\Http\Resources;

use Illuminate\Http\Resources\Json\JsonResource;

class PackageDetailResource extends JsonResource
{
    /**
     * Transform the resource into an array.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return array
     */
    public function toArray($request)
    {
        return [
            'start_date'        => $this->start_date ? $this->start_date->format('d M') : null,
            'end_date'          => $this->end_date ? $this->end_date->format('d M') : null,
            'duration_days'     => $this->duration_days,
            'duration_nights'   => $this->duration_nights,
            'itinerary_overview'=> $this->itinerary_overview,
            'includes'          => $this->includes ? array_map('trim', explode('#', $this->includes)) : [],
            'excludes'          => $this->excludes ? array_map('trim', explode('#', $this->excludes)) : [],
            'tour_highlights'   => $this->tour_highlights,
            'route_details'     => $this->route_details,
            'facilities'        => $this->facilities
        ];
    }
}


