<?php

namespace App\Http\Resources;

use Illuminate\Http\Resources\Json\JsonResource;

class HotelRoomResource extends JsonResource
{
    /**
     * Transform the resource into an array.
     */
    public function toArray($request)
    {
        return [
            'title'     => $this->title,
            'details'     => $this->details,
            'images' => $this->whenLoaded('images', function () {
                return $this->images->map(fn($img) => [
                    'image_path' => $img->image_path ? storage_link($img->image_path): null,
                    'image_alt' =>$img->title,
                ]);
            }),
        ];
    }
}
