<?php
namespace App\Http\Middleware;
use Closure;
use Illuminate\Http\Request;

class IsAdmin {
    public function handle(Request $request, Closure $next) {
        if (!$request->user() || !$request->user()->is_admin) {
            if ($request->expectsJson()) {
                return response()->json(['message'=>'Forbidden'], 403);
            }
            return redirect()->route('admin.login');
        }
        return $next($request);
    }
}
