<?php
namespace App\Http\Controllers\Api;
use App\Http\Controllers\Controller;
use App\Models\Booking;
use Illuminate\Http\Request;

class BookingController extends Controller {
    public function store(Request $r){
        $r->validate(['package_id'=>'required|exists:packages,id','start_date'=>'required|date','guests'=>'required|integer|min:1','customer_name'=>'required','customer_email'=>'required|email']);
        $user = $r->user();
        if($user){
            $booking = Booking::create(['user_id'=>$user->id,'package_id'=>$r->package_id,'start_date'=>$r->start_date,'end_date'=>$r->end_date,'guests'=>$r->guests,'total_price'=>$r->total_price ?? 0]);
        } else {
            // create anonymous booking with user_id = null not allowed because FK; recommend require auth or create guest handling
            return response()->json(['message'=>'Authentication required'],401);
        }
        return response()->json($booking,201);
    }
}
