<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use App\Models\PromotionalAd;

use Illuminate\Http\Request;
use Illuminate\Support\Str;
use Illuminate\Validation\ValidationException;
use Illuminate\Support\Facades\Validator;


class PromotionalAdsController extends Controller{

    public function index(Request $r){
        $ads = PromotionalAd::where('is_deleted','!=',1)
            ->orderBy(list_config()['order_by'], list_config()['direction'])
            ->paginate(25);
            return view('admin.settings.promotional', compact('ads'));
    }

    public function store(Request $r){
        $validator = Validator::make($r->all(), [
            'title'        => 'required|string|max:255',
            'link'         => 'required|string|max:255',
            'details'      => 'required|string',
            'type'         => 'required',
            'banner_image' => 'required|image',
        ]);

        // if ($validator->fails()) {
        //    echo $validator->errors();die;
        // }
        
        // die;
        $obj = [
            'link' => $r->link,
            'title' => $r->title,
            'details' => $r->details,
            'type' => $r->type,
            'banner_image_alt' => $r->banner_image_alt
        ];

        if ($r->hasFile('banner_image')) {
            $file = $r->file('banner_image');

            if ($file->isValid()) {
                // keep original filename
                $filename = $file->getClientOriginalName();

                // store in S3 under "tour_service/"
                $path = $file->storeAs('promotional_ads', $filename, 's3');

                $obj['banner_image'] = $path;
            }
        }

        // echo '<pre>';
        // print_r($obj);die;
        $service = PromotionalAd::create($obj);

        return redirect()
        ->route('admin.promotional-ads.index')
        ->with('success', 'Ads. create successfully');
    }

    public function edit(PromotionalAd $promotional_ad){
        $promotional_ad = PromotionalAd::where('id',$promotional_ad->id)->first();
        return response()->json($promotional_ad);
    }

    public function update(Request $r, PromotionalAd $promotional_ad){

        if (!$r->exists('status')) {
            $r->validate([
                'title' => 'required|string|max:255',
                'link' => 'required|string|max:255',
                'details' => 'required|string',
                'type' => 'required',
                'banner_image' => 'nullable|image|mimes:webp'
            ]);
            $path = $promotional_ad->banner_image ?? '';
            if ($r->hasFile('banner_image')) {
                $file = $r->file('banner_image');

                if ($file->isValid()) {
                    // delete old file if exists
                    if ($promotional_ad->banner_image && \Storage::disk('s3')->exists($promotional_ad->banner_image)) {
                        \Storage::disk('s3')->delete($promotional_ad->banner_image);
                    }

                    // keep original filename
                    $filename = $file->getClientOriginalName();

                    // store in S3 under "banner/" folder
                    $path = $file->storeAs('promotional_ads', $filename, 's3');

                    // $promotional_ad->banner_image = $path;
                    // $promotional_ad->save();
                }
            }

            $obj = [
                'title'       => $r->title,
                'link'   => $r->link,
                'details' => $r->details,
                'type' => $r->type,
                'banner_image'=> $path,
                'banner_image_alt' => $r->banner_image_alt
            ];


            $promotional_ad->update($obj);
        }  else {
            // Normal banner just update status
            $promotional_ad->is_active = $r->status ? 1 : 0;
            $promotional_ad->save();
        }
        
        // If AJAX request, return JSON response
        if ($r->ajax()) {
            return response()->json([
                'status'  => 'success',
                'message' => 'Ads. updated successfully',
                'data'    => $promotional_ad
            ]);
        }

        // Fallback for non-AJAX
        return redirect()
        ->route('admin.promotional-ads.index')
        ->with('success', 'Ads. updated successfully');
    }

    public function destroy(PromotionalAd $promotional_ad){
        $promotional_ad->delete();
        if ($promotional_ad->banner_image && \Storage::disk('s3')->exists($promotional_ad->banner_image)) {
            \Storage::disk('s3')->delete($promotional_ad->banner_image);
        }
        return response()->json(['success'=>true]);
    }
}
