<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use App\Models\Page;
use App\Models\PageFaq;
use App\Models\PageMetaData;
use Illuminate\Http\Request;
use Illuminate\Support\Str;
use Illuminate\Validation\ValidationException;


class PageController extends Controller{

    public function faqs(Request $r){
        $faqs = PageFaq::where('page_id',$r->id)->get();
        if ($r->ajax()) {
            return response()->json([
                'status'  => 'success',
                'faqs'    => $faqs
            ]);
        }
    }

    public function updateFaq(Request $r, Page $page){
        $page->faqs()->delete();
        if ($r->has('faqs')) {
            foreach ($r->faqs as $obj) {
                PageFaq::create([
                    'page_id'  => $page->id,
                    'question' => $obj['question'],
                    'answer'   => $obj['answer'] ?? null,
                ]);
            }
        }
        $url = getUrl($page->id)['url'];
        return redirect()->route($url)->with('success', 'Faq updated successfully');
    }

    public function showMeta(Page $page){
        $page->load('meta');
        return response()->json($page);
    }

    public function update(Request $r, Page $page){
        if($r->exists('meta_setting')) {
            $r->validate([
                'meta_title'       => 'nullable|string',
                'meta_description' => 'nullable|string',
                'meta_keywords'    => 'nullable|string',
                'h1_heading'       => 'nullable|string',
                'meta_details'     => 'nullable|string',
            ]);
            if ($page->meta) {
                //print_r($r->toArray());die;
                $page->meta->update([
                    'meta_title' => $r->meta_title,
                    'meta_description' => $r->meta_description,
                    'meta_keywords' => $r->meta_keywords,
                    'h1_heading' => $r->h1_heading,
                    'meta_details' => $r->meta_details,
                ]);
            } else {
                PageMetaData::create([
                    'page_id' => $page->id,
                    'meta_title' => $r->meta_title,
                    'meta_description' => $r->meta_description,
                    'meta_keywords' => $r->meta_keywords,
                    'h1_heading' => $r->h1_heading,
                    'meta_details' => $r->meta_details,
                ]);
            }
        } else {
            $validatedData = $r->validate([
                'title'        => 'required',
                'description'  => 'required',
                'banner_image' => 'sometimes|image|mimes:webp'
            ]);

            // You can now access the validated data.
            // For debugging, you can use dd() to "dump and die" and see the array.
            //dd($validatedData); die;
            $path = $page->banner_image ?? '';
            if ($r->hasFile('banner_image')) {
                if ($page->banner_image && \Storage::disk('s3')->exists($page->banner_image)) {
                    \Storage::disk('s3')->delete($page->banner_image);
                }

                $img = $r->file('banner_image');

                if ($img->isValid()) {
                    // keep original file name
                    $filename = $img->getClientOriginalName();

                    // store in "page/" folder on public disk
                    $path = $img->storeAs('page', $filename, 's3');
                }
            }

            $obj = [
                'title'       => $r->title,
                'description'   => $r->description,
                'banner_image'=> $path,
                'banner_image_alt' =>$r->banner_image_alt
            ];

            session()->flash('active_tab', getUrl($page->id)['page']);
            //print_r($obj);die;
            $page->update($obj);
        }
        $url = getUrl($page->id)['url'];
        return redirect()
        ->route($url)
        ->with('success', 'Page updated successfully');
    }



}
