<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;

class AuthController extends Controller {

    public function showLogin(){ 
        if (Auth::check() && auth()->user()->is_admin) {
            return redirect()->route('admin.dashboard');
        }
        return view('admin.auth.login'); 
    }

    public function login(Request $r){
        //echo $password = bcrypt('pass@123'); die;
        $r->validate(['email'=>'required|email','password'=>'required']);
        if (Auth::attempt($r->only('email','password'), $r->filled('remember'))) {
            //echo 'jhgjhgjgj';die;
            if (!auth()->user()->is_admin) {
                Auth::logout();
                return back()->withErrors(['email'=>'Not authorized as admin']);
            }
            
            return redirect()->route('admin.dashboard');
        }
        return back()->withErrors(['email'=>'Invalid credentials']);
    }
    
    public function logout(Request $r){
        Auth::logout();
        return redirect()->route('admin.login');
    }
}
