<?php

use App\Models\Category;
use App\Models\Continent;
use App\Models\Country;
use App\Models\Location;
use Illuminate\Support\Facades\Storage;
use Illuminate\Support\Collection;

if (!function_exists('list_config')) {
    function list_config() {
        $config = [
            'limit' => 10,
            'order_by' => 'id',
            'direction' => 'desc',
            'type' => 1, // default National
            'country' => 1 //default India
        ];
        return $config;
    }
}

if (!function_exists('invalidRequest')) {
    function invalidRequest()
    {
        return response()->json([
            'status'  => 'failed',
            'message' => 'Invalid Request'
        ], 404);
    }
}

if (!function_exists('getColor')) {
    function getColor() {
        $colors = [
            'bg-primary text-white',
            'bg-success text-white',
            'bg-danger text-white',
            'bg-info text-white',
        ];
        return $colors;
    }
}

if (!function_exists('getFleetType')) {
    function getFleetType() {
        $types = [
            'Economy',
            'Executive',
            'Luxury'
        ];
        return $types;
    }
}

// if (!function_exists('storage_link')) {
//     function storage_link($path) {
//         return asset('public/storage/'.$path);
//     }
// }



if (!function_exists('storage_link')) {
    function storage_link($path) {
        return $path ? Storage::disk('s3')->url($path) : null;
    }
}


if (!function_exists('public_link')) {
    function public_link($path) {
        return asset('public/'.$path);
    }
}

if (!function_exists('split_pipe')) {
    function split_pipe() {
        return '#';
    }
}

if (!function_exists('getPackageType')) {
    function getPackageType()
    {
        return [
            (object) ['id' => 1, 'name' => 'India Tour Package'],
            (object) ['id' => 2, 'name' => 'International Tour Package'],
        ];
    }
}

if (!function_exists('getPackageTypeName')) {
    function getPackageTypeName($id)
    {
        return collect(getPackageType())->firstWhere('id', $id)->name ?? null;
    }
}

if (!function_exists('getCategoryName')) {
    function getCategoryName($id)
    {
        return Category::find($id)?->name ?? null;
    }
}

if (!function_exists('getContinentName')) {
    function getContinentName($id)
    {
        return Continent::find($id)?->name ?? null;
    }
}

if (!function_exists('getCountryName')) {
    function getCountryName($id)
    {
        return Country::find($id)?->name ?? null;
    }
}

if (!function_exists('getLocationName')) {
    function getLocationName($id)
    {
        return Location::find($id)?->name ?? null;
    }
}

function getExecutedQuery($query)
{
    $sql = $query->toSql();
    $bindings = $query->getBindings();

    foreach ($bindings as $binding) {
        // Properly format the bindings for SQL
        $binding = is_numeric($binding) ? $binding : "'".addslashes($binding)."'";
        $sql = preg_replace('/\?/', $binding, $sql, 1);
    }

    return $sql;
}

function getUrl($page){
    $url = 'admin.page-settings.';
    $page_name = '';
    if($page == 1) {
        $url.= 'international';
        $page_name = 'international';
    }
    if($page == 3) {
        $url.= 'india';
        $page_name = 'india';
    }
    if($page == 4) {
        $url.= 'srilanka';
        $page_name = 'srilanka';
    }
    if($page == 2){
        $url.= 'luxury-train';
        $page_name = 'train_page';
    }
    if($page == 5){
        $url.= 'luxury-hotel';
        $page_name = 'hotel_page';
    }
    if($page == 6){
        $url.= 'car';
        $page_name = 'car_page';
    }
    if($page == 7){
        $url.= 'customized-holiday';
        $page_name = 'customized-holiday';
    }
    if($page == 8){
        $url.= 'home';
        $page_name = 'home';
    }
    return ['url'=>$url,'page'=>$page_name];
}



if (! function_exists('getRegionWiseCities')) {
    /**
     * Build region → state → cities structure from DB locations
     *
     * @param \Illuminate\Support\Collection $currentCities
     * @return array
     */
    function getRegionWiseCities(\Illuminate\Support\Collection $currentCities): array
    {
        // Load region mapping JSON
        $regionMapping = json_decode(getRegionWiseCitiesJson(), true);

        $menu = [];

        foreach ($regionMapping as $region => $states) {
            foreach ($states as $state => $cities) {
                // ✅ First: check if state name itself exists in DB
                $matchedStateCity = $currentCities->first(function ($item) use ($state) {
                    return stripos($item->name, $state) !== false;
                });

                if ($matchedStateCity) {
                    $menu[$region][$state] = $matchedStateCity;
                }

                // ✅ Then: check for each city under the state
                foreach ($cities as $cityName) {
                    $matchedCity = $currentCities->first(function ($item) use ($cityName) {
                        return stripos($item->name, $cityName) !== false;
                    });

                    if ($matchedCity) {
                        $menu[$region][$state]['cities'][] = $matchedCity;
                    }
                }
            }
        }

        return $menu;
    }
}

function getRegionWiseCitiesJson()
{
    return '{
        "North India": {
            "Himachal Pradesh": ["Manali", "Shimla", "Dharamshala", "Kasol", "Kullu", "Khajjiar", "Spiti Valley"],
            "Leh-Ladakh": ["Pangong Tso", "Khardung La", "Thiksey Monastery", "Leh Palace"],
            "Uttarakhand": ["Nainital", "Mussoorie", "Badrinath", "Kedarnath", "Valley of Flowers", "Haridwar", "Rishikesh"],
            "Kashmir": ["Srinagar", "Gulmarg", "Pahalgam", "Sonamarg"],
            "Uttar Pradesh": ["Ayodhya", "Agra", "Varanasi", "Lucknow", "Mathura", "Fatehpur Sikri", "Sarnath"],
            "Punjab & Haryana": ["Chandigarh", "Amritsar", "Jalandhar", "Kurukshetra"]
        },
        "South India": {
            "Kerala": ["Kochi", "Munnar", "Alleppey", "Kumarakom"],
            "Tamil Nadu": ["Chennai", "Madurai", "Ooty", "Kodaikanal"],
            "Karnataka": ["Bengaluru", "Mysore", "Coorg", "Hampi"]
        },
        "East & North East India": {
            "West Bengal": ["Kolkata", "Darjeeling", "Sundarbans"],
            "Assam": ["Kaziranga", "Guwahati"],
            "Meghalaya": ["Shillong", "Cherrapunji"],
            "Sikkim": ["Gangtok", "Lachung", "Yumthang Valley"]
        },
        "West & Central India": {
            "Rajasthan": ["Jaipur", "Udaipur", "Jodhpur", "Jaisalmer", "Mount Abu"],
            "Gujarat": ["Ahmedabad", "Gir National Park", "Somnath", "Dwarka"],
            "Madhya Pradesh": ["Bhopal", "Khajuraho", "Kanha", "Bandhavgarh"],
            "Maharashtra": ["Mumbai", "Pune", "Aurangabad", "Shirdi"]
        }
    }';
}

